
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kale_salads")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")

    # Set objective function
    m.setObjective(4.31 * x0 + 3.65 * x1 + 2.39 * x2 + 8.9 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(25 * x0 + 22 * x1 + 9 * x3 >= 57, "c0")
    m.addConstr(2 * x0 + 14 * x2 + 28 * x3 >= 72, "c1")
    m.addConstr(25 * x0 + 28 * x2 <= 163, "c2")
    m.addConstr(25 * x0 + 9 * x3 <= 299, "c3")
    m.addConstr(28 * x2 + 9 * x3 <= 103, "c4")
    m.addConstr(25 * x0 + 22 * x1 <= 281, "c5")
    m.addConstr(25 * x0 + 22 * x1 + 28 * x2 + 9 * x3 <= 281, "c6")
    m.addConstr(27 * x1 + 28 * x3 <= 247, "c7")
    m.addConstr(2 * x0 + 27 * x1 <= 321, "c8")
    m.addConstr(14 * x2 + 28 * x3 <= 318, "c9")
    m.addConstr(2 * x0 + 28 * x3 <= 310, "c10")
    m.addConstr(27 * x1 + 14 * x2 <= 93, "c11")
    m.addConstr(2 * x0 + 27 * x1 + 14 * x2 + 28 * x3 <= 93, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
