
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="corn_cobs", lb=0)
    x1 = model.addVar(name="kale_salads", lb=0)
    x2 = model.addVar(name="chicken_breasts", lb=0)
    x3 = model.addVar(name="slices_of_pizza", lb=0)

    # Define the objective function
    model.setObjective(4.31 * x0 + 3.65 * x1 + 2.39 * x2 + 8.9 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(25 * x0 + 22 * x1 + 28 * x2 + 9 * x3 >= 57)
    model.addConstr(2 * x0 + 14 * x2 + 28 * x3 >= 72)
    model.addConstr(25 * x0 + 28 * x2 <= 163)
    model.addConstr(25 * x0 + 9 * x3 <= 299)
    model.addConstr(28 * x2 + 9 * x3 <= 103)
    model.addConstr(25 * x0 + 22 * x1 <= 281)
    model.addConstr(25 * x0 + 22 * x1 + 28 * x2 + 9 * x3 <= 281)
    model.addConstr(27 * x1 + 28 * x3 <= 247)
    model.addConstr(2 * x0 + 27 * x1 <= 321)
    model.addConstr(14 * x2 + 28 * x3 <= 318)
    model.addConstr(2 * x0 + 28 * x3 <= 310)
    model.addConstr(27 * x1 + 14 * x2 <= 93)
    model.addConstr(2 * x0 + 27 * x1 + 14 * x2 + 28 * x3 <= 93)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("corn cobs: ", x0.varValue)
        print("kale salads: ", x1.varValue)
        print("chicken breasts: ", x2.varValue)
        print("slices of pizza: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
