
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
hamburgers = m.addVar(vtype=GRB.INTEGER, name="hamburgers")
eggs = m.addVar(vtype=GRB.INTEGER, name="eggs")
pickles = m.addVar(vtype=GRB.CONTINUOUS, name="pickles")
cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")
kiwis = m.addVar(vtype=GRB.INTEGER, name="kiwis")
chicken_thighs = m.addVar(vtype=GRB.INTEGER, name="chicken_thighs")
hot_dogs = m.addVar(vtype=GRB.INTEGER, name="hot_dogs")
fruit_salads = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")


# Set objective
m.setObjective(4*hamburgers**2 + 9*hamburgers*eggs + 7*hamburgers*chicken_thighs + 9*pickles*chicken_thighs + 6*cantaloupes*chicken_thighs + 9*bananas*hot_dogs + 4*bananas*fruit_salads + 8*kiwis*fruit_salads + 6*eggs + 9*pickles, GRB.MINIMIZE)

# Add constraints
m.addConstr(pickles * 9 + bananas * 9 >= 23)
m.addConstr(chicken_thighs * 2 + fruit_salads * 7 >= 27)
m.addConstr(pickles * 9 + hot_dogs * 17 >= 23)
m.addConstr(eggs**2 * 13 + bananas**2 * 9 >= 24)
m.addConstr(cantaloupes * 6 + kiwis * 12 >= 27)
m.addConstr(hamburgers * 1 + bananas * 9 >= 13)
m.addConstr(kiwis**2 * 12 + hot_dogs**2 * 17 >= 13)
m.addConstr(bananas * 9 + fruit_salads * 7 >= 11)
m.addConstr(bananas**2 * 9 + hot_dogs**2 * 17 >= 31)
m.addConstr(cantaloupes * 6 + bananas * 9 >= 14)
m.addConstr(eggs**2 * 13 + chicken_thighs**2 * 2 >= 11)
m.addConstr(hamburgers**2 * 1 + pickles**2 * 9 >= 13)
m.addConstr(kiwis * 12 + chicken_thighs * 2 >= 13)
m.addConstr(eggs * 13 + cantaloupes * 6 >= 14)
m.addConstr(hamburgers * 1 + chicken_thighs * 2 >= 28)
m.addConstr(pickles * 9 + kiwis * 12 >= 12)
m.addConstr(cantaloupes * 6 + fruit_salads * 7 >= 32)
m.addConstr(bananas * 9 + chicken_thighs * 2 >= 14)
m.addConstr(cantaloupes * 6 + hot_dogs * 17 >= 24)
m.addConstr(hamburgers * 1 + eggs * 13 + pickles * 9 + cantaloupes * 6 + bananas * 9 + kiwis * 12 + chicken_thighs * 2 + hot_dogs * 17 + fruit_salads * 7 >= 24)
m.addConstr(hamburgers * 17 + eggs * 7 >= 32)
m.addConstr(hamburgers * 17 + chicken_thighs * 15 >= 52)
m.addConstr(bananas * 6 + kiwis * 2 >= 43)
m.addConstr(pickles * 12 + kiwis * 2 >= 41)
m.addConstr(pickles * 12 + chicken_thighs * 15 >= 20)
m.addConstr(cantaloupes * 6 + chicken_thighs * 15 >= 22)
m.addConstr(kiwis * 2 + hot_dogs * 6 >= 21)
m.addConstr(hamburgers * 17 + cantaloupes * 6 >= 33)
m.addConstr(chicken_thighs * 15 + fruit_salads * 13 >= 47)
m.addConstr(hamburgers * 17 + hot_dogs * 6 >= 32)
m.addConstr(cantaloupes * 6 + fruit_salads * 13 >= 19)
m.addConstr(bananas * 6 + fruit_salads * 13 >= 33)
m.addConstr(cantaloupes * 6 + kiwis * 2 >= 18)
m.addConstr(hot_dogs * 6 + fruit_salads * 13 >= 42)


# carbohydrate and fiber upper bounds
m.addConstr(hamburgers * 1 + eggs * 13 + pickles * 9 + cantaloupes * 6 + bananas * 9 + kiwis * 12 + chicken_thighs * 2 + hot_dogs * 17 + fruit_salads * 7 <= 307)
m.addConstr(hamburgers * 17 + eggs * 7 + pickles * 12 + cantaloupes * 6 + bananas * 6 + kiwis * 2 + chicken_thighs * 15 + hot_dogs * 6 + fruit_salads * 13 <= 486)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

