
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")


    # Set objective function
    m.setObjective(2*x0 + 3*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 10*x2 >= 30, "c1")
    m.addConstr(2*x0 + 7*x1 >= 35, "c2")
    m.addConstr(x0 + 12*x2 >= 10, "c3")
    m.addConstr(6*x0 - 9*x1 >= 0, "c4")
    m.addConstr(2*x0 + 10*x2 <= 154, "c5")
    m.addConstr(7*x1 + 10*x2 <= 87, "c6")
    m.addConstr(2*x0 + 7*x1 + 10*x2 <= 87, "c7")  # Budget constraint
    m.addConstr(x0 + 12*x2 <= 62, "c8")
    m.addConstr(x0 + 15*x1 <= 28, "c9")
    m.addConstr(x0 + 15*x1 + 12*x2 <= 28, "c10") # Sustainability constraint
    m.addConstr(2*x0 + 7*x1 + 10*x2 <= 160, "dollar_cost")
    m.addConstr(x0 + 15*x1 + 12*x2 <= 80, "sustainability_score")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

