
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="rubber_gloves", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(2*x0 + 3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 10*x2 >= 30)
m.addConstr(2*x0 + 7*x1 >= 35)
m.addConstr(x0 + 12*x2 >= 10)
m.addConstr(6*x0 - 9*x1 >= 0)
m.addConstr(2*x0 + 10*x2 <= 154)
m.addConstr(7*x1 + 10*x2 <= 87)
m.addConstr(2*x0 + 7*x1 + 10*x2 <= 87)
m.addConstr(x0 + 12*x2 <= 62)
m.addConstr(x0 + 15*x1 <= 28)
m.addConstr(x0 + 15*x1 + 12*x2 <= 28)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("rubber gloves: ", x0.varValue)
    print("paper towel rolls: ", x1.varValue)
    print("diapers: ", x2.varValue)
else:
    print("The model is infeasible")
