
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x4")
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x5")

    # Objective function
    model.setObjective(5.86*x0 + 3.03*x1 + 1.04*x2 + 5.31*x3 + 6.45*x4 + 6.45*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5.77*x0 <= 233)
    model.addConstr(11.62*x1 <= 233)
    model.addConstr(9.44*x2 <= 233)
    model.addConstr(10.31*x3 <= 233)
    model.addConstr(4.23*x4 <= 233)
    model.addConstr(2.99*x5 <= 233)
    model.addConstr(5.77*x0 + 9.44*x2 >= 34)
    model.addConstr(9.87*x0 <= 389)
    model.addConstr(1.37*x1 <= 389)
    model.addConstr(8.47*x2 <= 389)
    model.addConstr(11.49*x3 <= 389)
    model.addConstr(4.72*x4 <= 389)
    model.addConstr(9.52*x5 <= 389)
    model.addConstr(8.47*x2 + 11.49*x3 >= 52)
    model.addConstr(4.72*x4 + 9.52*x5 >= 26)
    model.addConstr(11.49*x3 + 9.52*x5 >= 53)
    model.addConstr(9.87*x0 + 9.52*x5 >= 24)
    model.addConstr(9.87*x0 + 4.72*x4 >= 39)
    model.addConstr(9.87*x0 + 8.47*x2 >= 31)
    model.addConstr(9.87*x0 + 11.49*x3 >= 55)
    model.addConstr(-6*x1 + 2*x4 >= 0)
    model.addConstr(2*x4 - x5 >= 0)
    model.addConstr(5.77*x0 + 10.31*x3 <= 64)
    model.addConstr(9.44*x2 + 2.99*x5 <= 87)
    model.addConstr(11.62*x1 + 9.44*x2 <= 136)
    model.addConstr(5.77*x0 + 11.62*x1 <= 55)
    model.addConstr(11.62*x1 + 4.23*x4 <= 190)
    model.addConstr(5.77*x0 + 2.99*x5 <= 133)
    model.addConstr(4.23*x4 + 2.99*x5 <= 197)
    model.addConstr(5.77*x0 + 9.44*x2 + 10.31*x3 <= 165)
    model.addConstr(11.62*x1 + 9.44*x2 + 2.99*x5 <= 79)
    model.addConstr(11.62*x1 + 10.31*x3 + 2.99*x5 <= 210)
    model.addConstr(5.77*x0 + 4.23*x4 + 2.99*x5 <= 222)
    model.addConstr(9.87*x0 + 9.52*x5 <= 317)
    model.addConstr(1.37*x1 + 4.72*x4 <= 117)
    model.addConstr(8.47*x2 + 9.52*x5 <= 70)
    model.addConstr(8.47*x2 + 11.49*x3 <= 309)
    model.addConstr(8.47*x2 + 4.72*x4 <= 163)
    model.addConstr(9.87*x0 + 8.47*x2 <= 357)
    model.addConstr(11.49*x3 + 9.52*x5 <= 311)
    model.addConstr(9.87*x0 + 4.72*x4 <= 77)
    model.addConstr(1.37*x1 + 8.47*x2 + 9.52*x5 <= 190)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("x0:", x0.varValue)
        print("x1:", x1.varValue)
        print("x2:", x2.varValue)
        print("x3:", x3.varValue)
        print("x4:", x4.varValue)
        print("x5:", x5.varValue)
        print("Objective:", model.objVal)
    else:
        print("No optimal solution found.")

optimize_problem()
