
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="candles", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="bottles_of_ibuprofen", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="toilet_paper_rolls", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5.11*x1 + 5.61*x2 + 1.51*x3 + 8.4*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(21*x1 + 10*x3 >= 12)
    model.addConstr(21*x1 + 16*x2 + 6*x4 >= 22)
    model.addConstr(21*x1 + 16*x2 <= 88)
    model.addConstr(21*x1 + 6*x4 <= 129)
    model.addConstr(16*x2 + 10*x3 <= 129)
    model.addConstr(10*x3 + 6*x4 <= 116)
    model.addConstr(21*x1 + 16*x2 + 6*x4 <= 140)
    model.addConstr(21*x1 + 16*x2 + 10*x3 + 6*x4 <= 151)
    model.addConstr(5*x1 + 7*x2 <= 126)
    model.addConstr(5*x1 + 15*x4 <= 95)
    model.addConstr(5*x1 + 22*x3 + 15*x4 <= 79)
    model.addConstr(5*x1 + 7*x2 + 22*x3 + 15*x4 <= 79)

    # Set bounds for variables
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)
    model.addConstr(x4 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Candles: {x1.varValue}")
        print(f"Dish soap bottles: {x2.varValue}")
        print(f"Bottles of ibuprofen: {x3.varValue}")
        print(f"Toilet paper rolls: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
