
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B6
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # grams of protein
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B5
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of zinc


    # Set objective function
    m.setObjective(9*x0 + 3*x1 + 9*x2 + 2*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10*x2 + 4*x1 >= 6)
    m.addConstr(11*x0 + 4*x1 >= 9)
    m.addConstr(11*x0 + 4*x3 >= 13)
    m.addConstr(10*x2 + 4*x3 >= 13)
    m.addConstr(9*x0 + 11*x1 >= 25)
    m.addConstr(9*x0 + 11*x1 + 4*x3 >= 27)
    m.addConstr(6*x0 + 10*x2 >= 9)
    m.addConstr(9*x1 + 10*x2 >= 7)
    m.addConstr(11*x0 + 9*x1 + 2*x2 >= 13)
    m.addConstr(11*x0 + 4*x1 <= 18)
    m.addConstr(11*x0 + 10*x2 <= 17)
    m.addConstr(4*x1 + 10*x2 + 4*x3 <= 26)
    m.addConstr(11*x0 + 4*x1 + 10*x2 <= 56)
    m.addConstr(11*x0 + 4*x1 + 4*x3 <= 31)
    m.addConstr(11*x0 + 4*x1 + 10*x2 + 4*x3 <= 31)
    m.addConstr(9*x0 + 11*x1 <= 91)
    m.addConstr(9*x0 + 4*x3 <= 65)
    m.addConstr(8*x2 + 4*x3 <= 44)
    m.addConstr(11*x1 + 4*x3 <= 114)
    m.addConstr(11*x1 + 8*x2 <= 114)
    m.addConstr(9*x0 + 11*x1 + 8*x2 + 4*x3 <= 114)
    m.addConstr(9*x1 + 11*x3 <= 43)
    m.addConstr(6*x0 + 10*x2 <= 23)
    m.addConstr(9*x1 + 10*x2 <= 36)
    m.addConstr(6*x0 + 11*x3 <= 41)
    m.addConstr(10*x2 + 11*x3 <= 44)
    m.addConstr(6*x0 + 9*x1 + 10*x2 <= 50)
    m.addConstr(6*x0 + 10*x2 + 11*x3 <= 67)
    m.addConstr(6*x0 + 9*x1 + 10*x2 + 11*x3 <= 67)
    m.addConstr(11*x0 + 9*x1 <= 41)
    m.addConstr(9*x1 + 2*x2 <= 24)
    m.addConstr(11*x0 + 4*x3 <= 40)
    m.addConstr(11*x0 + 9*x1 + 2*x2 + 4*x3 <= 40)

    # Resource constraints
    m.addConstr(11*x0 + 4*x1 + 10*x2 + 4*x3 <= 61)
    m.addConstr(9*x0 + 11*x1 + 8*x2 + 4*x3 <= 117)
    m.addConstr(6*x0 + 9*x1 + 10*x2 + 11*x3 <= 74)
    m.addConstr(11*x0 + 9*x1 + 2*x2 + 4*x3 <= 78)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
