
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B6
    x2 = model.addVar(name="x2", lb=0)  # grams of protein
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B5
    x4 = model.addVar(name="x4", lb=0)  # milligrams of zinc

    # Objective function
    model.setObjective(9 * x1 + 3 * x2 + 9 * x3 + 2 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x2 + 10 * x3 >= 6)
    model.addConstr(11 * x1 + 4 * x2 >= 9)
    model.addConstr(11 * x1 + 4 * x4 >= 13)
    model.addConstr(10 * x3 + 4 * x4 >= 13)
    model.addConstr(9 * x1 + 11 * x2 >= 25)
    model.addConstr(9 * x1 + 11 * x2 + 4 * x4 >= 27)
    model.addConstr(6 * x1 + 10 * x3 >= 9)
    model.addConstr(9 * x2 + 10 * x3 >= 7)
    model.addConstr(11 * x1 + 9 * x2 + 2 * x3 >= 13)
    model.addConstr(11 * x1 + 4 * x2 <= 18)
    model.addConstr(11 * x1 + 10 * x3 <= 17)
    model.addConstr(4 * x2 + 10 * x3 + 4 * x4 <= 26)
    model.addConstr(11 * x1 + 4 * x2 + 10 * x3 <= 56)
    model.addConstr(11 * x1 + 4 * x2 + 4 * x4 <= 31)
    model.addConstr(11 * x1 + 4 * x2 + 10 * x3 + 4 * x4 <= 31)
    model.addConstr(9 * x1 + 11 * x2 <= 91)
    model.addConstr(9 * x1 + 4 * x4 <= 65)
    model.addConstr(8 * x3 + 4 * x4 <= 44)
    model.addConstr(11 * x2 + 4 * x4 <= 114)
    model.addConstr(11 * x2 + 8 * x3 <= 114)
    model.addConstr(9 * x1 + 11 * x2 + 8 * x3 + 4 * x4 <= 114)
    model.addConstr(9 * x2 + 11 * x4 <= 43)
    model.addConstr(6 * x1 + 10 * x3 <= 23)
    model.addConstr(9 * x2 + 10 * x3 <= 36)
    model.addConstr(6 * x1 + 11 * x4 <= 41)
    model.addConstr(10 * x3 + 11 * x4 <= 44)
    model.addConstr(6 * x1 + 9 * x2 + 10 * x3 <= 50)
    model.addConstr(6 * x1 + 10 * x3 + 11 * x4 <= 67)
    model.addConstr(6 * x1 + 9 * x2 + 10 * x3 + 11 * x4 <= 67)
    model.addConstr(11 * x1 + 9 * x2 <= 41)
    model.addConstr(9 * x2 + 2 * x3 <= 24)
    model.addConstr(11 * x1 + 4 * x4 <= 40)
    model.addConstr(11 * x1 + 9 * x2 + 2 * x3 + 4 * x4 <= 40)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B6: {x1.varValue}")
        print(f"Grams of protein: {x2.varValue}")
        print(f"Milligrams of vitamin B5: {x3.varValue}")
        print(f"Milligrams of zinc: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
