
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")


    # Set objective function
    m.setObjective(4*x0 + 3*x1 + x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 7*x1 + 14*x2 <= 124, "c0")
    m.addConstr(6*x0 + 16*x1 + 20*x2 <= 154, "c1")
    m.addConstr(20*x0 + 1*x1 + 3*x2 <= 137, "c2")
    m.addConstr(7*x1 + 14*x2 >= 20, "c3")
    m.addConstr(11*x0 + 7*x1 >= 29, "c4")
    m.addConstr(11*x0 + 7*x1 + 14*x2 >= 21, "c5")
    m.addConstr(16*x1 + 20*x2 >= 29, "c6")
    m.addConstr(6*x0 + 16*x1 >= 49, "c7")
    m.addConstr(6*x0 + 20*x2 >= 46, "c8")
    m.addConstr(6*x0 + 16*x1 + 20*x2 >= 32, "c9")
    m.addConstr(1*x1 + 3*x2 >= 17, "c10")
    m.addConstr(20*x0 + 3*x2 >= 16, "c11")
    m.addConstr(20*x0 + 1*x1 + 3*x2 >= 16, "c12")
    m.addConstr(-9*x1 + 9*x2 >= 0, "c13")
    m.addConstr(-1*x0 + 2*x2 >= 0, "c14")
    m.addConstr(16*x1 + 20*x2 <= 142, "c15")
    m.addConstr(6*x0 + 20*x2 <= 53, "c16")
    m.addConstr(6*x0 + 16*x1 + 20*x2 <= 154, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
