
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
    vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")

    # Set objective function
    m.setObjective(5*vitamin_k + 1*vitamin_b3 + 9*vitamin_e + 1*vitamin_b12, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1*vitamin_k + 20*vitamin_b3 >= 91, "c1")
    m.addConstr(20*vitamin_b3 + 12*vitamin_e >= 49, "c2")
    m.addConstr(1*vitamin_k + 16*vitamin_b12 >= 82, "c3")
    m.addConstr(20*vitamin_b3 + 16*vitamin_b12 >= 69, "c4")
    m.addConstr(1*vitamin_k + 20*vitamin_b3 + 12*vitamin_e + 16*vitamin_b12 >= 69, "c5")
    m.addConstr(1*vitamin_b3 - 5*vitamin_b12 >= 0, "c6")
    m.addConstr(4*vitamin_k - 4*vitamin_b12 >= 0, "c7")
    m.addConstr(9*vitamin_k - 7*vitamin_e + 7*vitamin_b12 >= 0, "c8")
    m.addConstr(1*vitamin_k + 16*vitamin_b12 <= 147, "c9")
    m.addConstr(1*vitamin_k + 20*vitamin_b3 <= 275, "c10")
    m.addConstr(12*vitamin_e + 16*vitamin_b12 <= 378, "c11")
    m.addConstr(1*vitamin_k + 20*vitamin_b3 + 12*vitamin_e <= 228, "c12")
    m.addConstr(1*vitamin_k + 20*vitamin_b3 + 12*vitamin_e + 16*vitamin_b12 <= 383, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
