
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin K
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B3
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin E
    x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin B12

    # Define the objective function
    model.setObjective(5 * x1 + 1 * x2 + 9 * x3 + 1 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 + 20 * x2 >= 91)
    model.addConstr(20 * x2 + 12 * x3 >= 49)
    model.addConstr(x1 + 16 * x4 >= 82)
    model.addConstr(20 * x2 + 16 * x4 >= 69)
    model.addConstr(x1 + 20 * x2 + 12 * x3 + 16 * x4 >= 69)
    model.addConstr(x2 - 5 * x4 >= 0)
    model.addConstr(4 * x1 - 4 * x4 >= 0)
    model.addConstr(9 * x1 - 7 * x3 + 7 * x4 >= 0)
    model.addConstr(x1 + 16 * x4 <= 147)
    model.addConstr(x1 + 20 * x2 <= 275)
    model.addConstr(12 * x3 + 16 * x4 <= 378)
    model.addConstr(x1 + 20 * x2 + 12 * x3 <= 228)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {x1.varValue}")
        print(f"Milligrams of vitamin B3: {x2.varValue}")
        print(f"Milligrams of vitamin E: {x3.varValue}")
        print(f"Milligrams of vitamin B12: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
