
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_plant_cost")

# Create variables
basil = m.addVar(vtype=GRB.INTEGER, name="basil_plants")
verbenas = m.addVar(vtype=GRB.INTEGER, name="verbenas")


# Set objective function
m.setObjective(4.77 * basil + 2.3 * verbenas, GRB.MINIMIZE)

# Add constraints
m.addConstr(8.95 * basil + 10.05 * verbenas >= 8, "beauty_rating_min")
m.addConstr(-8 * basil + 4 * verbenas >= 0, "plant_ratio")
m.addConstr(8.95 * basil + 10.05 * verbenas <= 29, "beauty_rating_max")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of basil plants: {basil.x}")
    print(f"Number of verbenas: {verbenas.x}")

