
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="basil_plants")
x2 = m.addVar(vtype=GRB.INTEGER, name="verbenas")

# Set the objective function
m.setObjective(4.77*x1 + 2.3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(8.95*x1 + 10.05*x2 >= 8, "beauty_rating_min")
m.addConstr(-8*x1 + 4*x2 >= 0, "resource_constraint")
m.addConstr(8.95*x1 + 10.05*x2 <= 29, "beauty_rating_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of basil plants: {x1.x}")
    print(f"Number of verbenas: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
