
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='basil_plants', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='verbenas', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4.77 * x1 + 2.3 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8.95 * x1 + 10.05 * x2 >= 8)
    model.addConstr(-8 * x1 + 4 * x2 >= 0)
    model.addConstr(8.95 * x1 + 10.05 * x2 <= 29)

    # Non-negativity constraints
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Basil plants: {x1.varValue}')
        print(f'Verbenas: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
