
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bobby", "Hank", "George", "Paul"])


    # Set objective function
    m.setObjective(9*x[0] + 9*x[1] + 9*x[2] + 5*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12.31*x[0] + 5.88*x[1] >= 27)
    m.addConstr(14.3*x[2] + 12.49*x[3] >= 27)
    m.addConstr(5.88*x[1] + 14.3*x[2] >= 30)
    m.addConstr(6.47*x[0] + 7.82*x[1] + 6.71*x[2] >= 40)
    m.addConstr(7.82*x[1] + 6.71*x[2] + 11.73*x[3] >= 40)
    m.addConstr(6.47*x[0] + 7.82*x[1] + 11.73*x[3] >= 40)
    m.addConstr(6.71*x[2] + 11.73*x[3] >= 14)
    m.addConstr(7.82*x[1] + 11.73*x[3] >= 24)
    m.addConstr(7.82*x[1] + 6.71*x[2] + 11.73*x[3] >= 22)
    m.addConstr(6.47*x[0] + 7.82*x[1] + 11.73*x[3] >= 22)
    m.addConstr(6.47*x[0] + 7.82*x[1] + 6.71*x[2] >= 22)
    m.addConstr(12.31*x[0] + 5.88*x[1] <= 68)
    m.addConstr(5.88*x[1] + 14.3*x[2] <= 76)
    m.addConstr(12.31*x[0] + 14.3*x[2] <= 99)
    m.addConstr(12.31*x[0] + 5.88*x[1] + 14.3*x[2] + 12.49*x[3] <= 99)
    m.addConstr(6.47*x[0] + 6.71*x[2] <= 65)
    m.addConstr(7.82*x[1] + 11.73*x[3] <= 141)
    m.addConstr(6.71*x[2] + 11.73*x[3] <= 123)
    m.addConstr(7.82*x[1] + 6.71*x[2] + 11.73*x[3] <= 145)
    m.addConstr(6.47*x[0] + 7.82*x[1] + 6.71*x[2] + 11.73*x[3] <= 145)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
