
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # hours worked by Bobby
x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
x2 = model.addVar(name="x2", lb=0)  # hours worked by George
x3 = model.addVar(name="x3", lb=0)  # hours worked by Paul

# Define the objective function
model.setObjective(9 * x0 + 9 * x1 + 9 * x2 + 5 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12.31 * x0 <= 135)
model.addConstr(6.47 * x0 <= 164)
model.addConstr(5.88 * x1 <= 135)
model.addConstr(7.82 * x1 <= 164)
model.addConstr(14.3 * x2 <= 135)
model.addConstr(6.71 * x2 <= 164)
model.addConstr(12.49 * x3 <= 135)
model.addConstr(11.73 * x3 <= 164)
model.addConstr(5.88 * x1 + 14.3 * x2 >= 30)
model.addConstr(12.31 * x0 + 5.88 * x1 >= 27)
model.addConstr(14.3 * x2 + 12.49 * x3 >= 27)
model.addConstr(6.71 * x2 + 11.73 * x3 >= 14)
model.addConstr(7.82 * x1 + 11.73 * x3 >= 24)
model.addConstr(7.82 * x1 + 6.71 * x2 + 11.73 * x3 >= 40)
model.addConstr(6.47 * x0 + 7.82 * x1 + 11.73 * x3 >= 40)
model.addConstr(6.47 * x0 + 7.82 * x1 + 6.71 * x2 >= 40)
model.addConstr(7.82 * x1 + 6.71 * x2 + 11.73 * x3 >= 40)
model.addConstr(6.47 * x0 + 7.82 * x1 + 11.73 * x3 >= 40)
model.addConstr(6.47 * x0 + 7.82 * x1 + 6.71 * x2 >= 40)
model.addConstr(7.82 * x1 + 6.71 * x2 + 11.73 * x3 >= 22)
model.addConstr(6.47 * x0 + 7.82 * x1 + 11.73 * x3 >= 22)
model.addConstr(6.47 * x0 + 7.82 * x1 + 6.71 * x2 >= 22)
model.addConstr(5.88 * x1 + 14.3 * x2 <= 76)
model.addConstr(12.31 * x0 + 5.88 * x1 <= 68)
model.addConstr(12.31 * x0 + 14.3 * x2 <= 99)
model.addConstr(12.31 * x0 + 5.88 * x1 + 14.3 * x2 + 12.49 * x3 <= 99)
model.addConstr(6.47 * x0 + 6.71 * x2 <= 65)
model.addConstr(7.82 * x1 + 11.73 * x3 <= 141)
model.addConstr(6.71 * x2 + 11.73 * x3 <= 123)
model.addConstr(7.82 * x1 + 6.71 * x2 + 11.73 * x3 <= 145)
model.addConstr(6.47 * x0 + 7.82 * x1 + 6.71 * x2 + 11.73 * x3 <= 145)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by Hank: ", x1.varValue)
    print("Hours worked by George: ", x2.varValue)
    print("Hours worked by Paul: ", x3.varValue)
else:
    print("The model is infeasible")
