
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")


    # Set objective function
    m.setObjective(9 * vitamin_e + 4 * vitamin_b6, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7.36 * vitamin_e + 4.97 * vitamin_b6 >= 58, "energy_stability_min")
    m.addConstr(8.27 * vitamin_e + 5.05 * vitamin_b6 >= 25, "digestive_support_min")
    m.addConstr(3 * vitamin_e - 4 * vitamin_b6 >= 0, "vitamin_ratio")
    m.addConstr(7.36 * vitamin_e + 4.97 * vitamin_b6 <= 91, "energy_stability_max")
    m.addConstr(8.27 * vitamin_e + 5.05 * vitamin_b6 <= 47, "digestive_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Milligrams of Vitamin E: {vitamin_e.x}")
        print(f"Milligrams of Vitamin B6: {vitamin_b6.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
