
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")

# Set the objective function
m.setObjective(9*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7.36*x1 + 4.97*x2 >= 58, "energy_stability_index_min")
m.addConstr(8.27*x1 + 5.05*x2 >= 25, "digestive_support_index_min")
m.addConstr(3*x1 - 4*x2 >= 0, "vitamin_ratio_constraint")
m.addConstr(7.36*x1 + 4.97*x2 <= 91, "energy_stability_index_max")
m.addConstr(8.27*x1 + 5.05*x2 <= 47, "digestive_support_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x1.x}")
    print(f"Milligrams of Vitamin B6: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
