
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin E
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B6

    # Objective function: maximize 9*x1 + 4*x2
    model.setObjective(9*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7.36*x1 + 4.97*x2 >= 58)
    model.addConstr(8.27*x1 + 5.05*x2 >= 25)
    model.addConstr(3*x1 - 4*x2 >= 0)
    model.addConstr(7.36*x1 + 4.97*x2 <= 91)
    model.addConstr(8.27*x1 + 5.05*x2 <= 47)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
