
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")

# Set objective function
m.setObjective(8*corn_cobs + 8*lemons + 7*oranges + 5*hot_dogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15*oranges + 9*hot_dogs >= 48)
m.addConstr(15*corn_cobs + 13*lemons >= 49)
m.addConstr(15*corn_cobs + 9*hot_dogs >= 37)
m.addConstr(13*lemons + 9*hot_dogs >= 43)
m.addConstr(15*corn_cobs + 13*lemons + 15*oranges + 9*hot_dogs >= 43)
m.addConstr(11*corn_cobs + 11*oranges >= 25)
m.addConstr(11*corn_cobs + 15*lemons >= 40)
m.addConstr(11*corn_cobs + 15*lemons + 11*oranges + 16*hot_dogs >= 40)
m.addConstr(2*lemons + 3*oranges >= 26)
m.addConstr(7*corn_cobs + 12*hot_dogs >= 37)
m.addConstr(7*corn_cobs + 2*lemons >= 32)
m.addConstr(7*corn_cobs + 2*lemons + 3*oranges + 12*hot_dogs >= 32)
m.addConstr(8*corn_cobs - 10*lemons >= 0)
m.addConstr(-6*lemons + 2*hot_dogs >= 0)
m.addConstr(13*lemons + 15*oranges + 9*hot_dogs <= 149)
m.addConstr(15*corn_cobs + 13*lemons + 9*hot_dogs <= 105)
m.addConstr(11*corn_cobs + 11*oranges <= 129)
m.addConstr(15*lemons + 11*oranges <= 131)
m.addConstr(15*lemons + 16*hot_dogs <= 104)
m.addConstr(11*corn_cobs + 16*hot_dogs <= 121)
m.addConstr(7*corn_cobs + 2*lemons + 3*oranges <= 152)

# Resource Constraints
m.addConstr(15*corn_cobs + 13*lemons + 15*oranges + 9*hot_dogs <= 205) # Fiber
m.addConstr(11*corn_cobs + 15*lemons + 11*oranges + 16*hot_dogs <= 162) # Tastiness
m.addConstr(7*corn_cobs + 2*lemons + 3*oranges + 12*hot_dogs <= 205) # Fat


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

