
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='corn_cobs', lb=0)
x1 = m.addVar(name='lemons', lb=0)
x2 = m.addVar(name='oranges', lb=0)
x3 = m.addVar(name='hot_dogs', lb=0)

# Set the objective function
m.setObjective(8*x0 + 8*x1 + 7*x2 + 5*x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x0 + 13*x1 + 15*x2 + 9*x3 <= 205)
m.addConstr(11*x0 + 15*x1 + 11*x2 + 16*x3 <= 162)
m.addConstr(7*x0 + 2*x1 + 3*x2 + 12*x3 <= 205)
m.addConstr(15*x2 + 9*x3 >= 48)
m.addConstr(15*x0 + 13*x1 >= 49)
m.addConstr(15*x0 + 9*x3 >= 37)
m.addConstr(13*x1 + 9*x3 >= 43)
m.addConstr(15*x0 + 13*x1 + 15*x2 + 9*x3 >= 43)
m.addConstr(11*x0 + 11*x2 >= 25)
m.addConstr(11*x0 + 15*x1 >= 40)
m.addConstr(11*x0 + 15*x1 + 11*x2 + 16*x3 >= 40)
m.addConstr(2*x1 + 3*x2 >= 26)
m.addConstr(7*x0 + 12*x3 >= 37)
m.addConstr(7*x0 + 2*x1 >= 32)
m.addConstr(7*x0 + 2*x1 + 3*x2 + 12*x3 >= 32)
m.addConstr(8*x0 - 10*x1 >= 0)
m.addConstr(-6*x1 + 2*x3 >= 0)
m.addConstr(13*x1 + 15*x2 + 9*x3 <= 149)
m.addConstr(15*x0 + 13*x1 + 9*x3 <= 105)
m.addConstr(11*x0 + 11*x2 <= 129)
m.addConstr(15*x1 + 11*x2 <= 131)
m.addConstr(15*x1 + 16*x3 <= 104)
m.addConstr(11*x0 + 16*x3 <= 121)
m.addConstr(7*x0 + 2*x1 + 3*x2 <= 152)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('corn cobs: ', x0.varValue)
    print('lemons: ', x1.varValue)
    print('oranges: ', x2.varValue)
    print('hot dogs: ', x3.varValue)
else:
    print('No solution found')
