
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
john = model.addVar(vtype=gp.GRB.INTEGER, name="john")


# Set objective function
model.setObjective(6*hank + 7*paul + 5*laura + 3*john, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(14*hank + 12*john >= 26)
model.addConstr(4*paul + 13*laura >= 15)
model.addConstr(14*hank + 13*laura + 12*john >= 15)
model.addConstr(4*paul + 13*laura + 12*john >= 15)
model.addConstr(14*hank + 4*paul + 13*laura >= 15)
model.addConstr(14*hank + 13*laura + 12*john >= 14)
model.addConstr(4*paul + 13*laura + 12*john >= 14)
model.addConstr(14*hank + 4*paul + 13*laura >= 14)
model.addConstr(14*hank + 13*laura + 12*john >= 20)
model.addConstr(4*paul + 13*laura + 12*john >= 20)
model.addConstr(14*hank + 4*paul + 13*laura >= 20)
model.addConstr(17*laura + 10*john >= 39)
model.addConstr(8*hank + 17*laura + 10*john >= 41)
model.addConstr(13*laura + 12*john <= 93)
model.addConstr(4*paul + 12*john <= 87)
model.addConstr(14*hank + 4*paul <= 48)
model.addConstr(14*hank + 12*john <= 49)
model.addConstr(14*hank + 13*laura <= 29)
model.addConstr(14*hank + 4*paul + 12*john <= 111)
model.addConstr(14*hank + 13*laura + 12*john <= 73)
model.addConstr(4*paul + 13*laura + 12*john <= 62)
model.addConstr(14*hank + 4*paul + 13*laura <= 79)
model.addConstr(14*hank + 4*paul + 13*laura + 12*john <= 79)
model.addConstr(17*laura + 10*john <= 80)
model.addConstr(8*hank + 17*laura <= 164)
model.addConstr(8*hank + 13*paul <= 87)
model.addConstr(13*paul + 17*laura <= 217)
model.addConstr(8*hank + 13*paul + 17*laura <= 136)
model.addConstr(8*hank + 13*paul + 10*john <= 247)
model.addConstr(13*paul + 17*laura + 10*john <= 88)
model.addConstr(8*hank + 13*paul + 17*laura + 10*john <= 88)
model.addConstr(11*hank + 18*paul <= 68)
model.addConstr(11*hank + 13*john <= 46)
model.addConstr(11*hank + 18*paul + 18*laura + 13*john <= 46)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hank: {hank.x}")
    print(f"Paul: {paul.x}")
    print(f"Laura: {laura.x}")
    print(f"John: {john.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

