
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Hank
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Paul
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Laura
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # hours worked by John

# Define the objective function
m.setObjective(6 * x0 + 7 * x1 + 5 * x2 + 3 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x0 + 12 * x3 >= 26)
m.addConstr(4 * x1 + 13 * x2 >= 15)
m.addConstr(14 * x0 + 13 * x2 + 12 * x3 >= 15)
m.addConstr(4 * x1 + 13 * x2 + 10 * x3 >= 15)
m.addConstr(14 * x0 + 4 * x1 + 13 * x2 >= 15)
m.addConstr(14 * x0 + 13 * x2 + 12 * x3 >= 14)
m.addConstr(4 * x1 + 13 * x2 + 10 * x3 >= 14)
m.addConstr(14 * x0 + 4 * x1 + 13 * x2 >= 14)
m.addConstr(14 * x0 + 13 * x2 + 12 * x3 >= 20)
m.addConstr(4 * x1 + 13 * x2 + 10 * x3 >= 20)
m.addConstr(14 * x0 + 4 * x1 + 13 * x2 >= 20)
m.addConstr(17 * x2 + 10 * x3 >= 39)
m.addConstr(8 * x0 + 17 * x2 + 10 * x3 >= 41)
m.addConstr(13 * x2 + 12 * x3 <= 93)
m.addConstr(4 * x1 + 12 * x3 <= 87)
m.addConstr(14 * x0 + 4 * x1 <= 48)
m.addConstr(14 * x0 + 12 * x3 <= 49)
m.addConstr(14 * x0 + 13 * x2 <= 29)
m.addConstr(14 * x0 + 4 * x1 + 12 * x3 <= 111)
m.addConstr(14 * x0 + 13 * x2 + 12 * x3 <= 73)
m.addConstr(4 * x1 + 13 * x2 + 10 * x3 <= 62)
m.addConstr(14 * x0 + 4 * x1 + 13 * x2 <= 79)
m.addConstr(14 * x0 + 4 * x1 + 13 * x2 + 12 * x3 <= 79)
m.addConstr(17 * x2 + 10 * x3 <= 80)
m.addConstr(8 * x0 + 17 * x2 <= 164)
m.addConstr(8 * x0 + 13 * x1 <= 87)
m.addConstr(13 * x1 + 17 * x2 <= 217)
m.addConstr(8 * x0 + 13 * x1 + 17 * x2 <= 136)
m.addConstr(8 * x0 + 13 * x1 + 10 * x3 <= 247)
m.addConstr(13 * x1 + 17 * x2 + 10 * x3 <= 88)
m.addConstr(8 * x0 + 13 * x1 + 17 * x2 + 10 * x3 <= 88)
m.addConstr(11 * x0 + 18 * x1 <= 68)
m.addConstr(11 * x0 + 13 * x3 <= 46)
m.addConstr(11 * x0 + 18 * x1 + 18 * x2 + 13 * x3 <= 46)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by John: ", x3.varValue)
else:
    print("The model is infeasible")
