
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(name="vitamin_B9")  # milligrams of vitamin B9
    x1 = m.addVar(name="vitamin_B6")  # milligrams of vitamin B6


    # Set objective function
    m.setObjective(2*x0 + 3*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*x0 + 8*x1 >= 35, "energy_stability_lower")
    m.addConstr(1*x0 + 5*x1 >= 14, "cardiovascular_support_lower")
    m.addConstr(-4*x0 + 10*x1 >= 0, "constraint_3")
    m.addConstr(10*x0 + 8*x1 <= 54, "energy_stability_upper")
    m.addConstr(1*x0 + 5*x1 <= 33, "cardiovascular_support_upper")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin B9: %g' % x0.x)
        print('Vitamin B6: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

