
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_B9", lb=0, ub=None)
    x2 = model.addVar(name="milligrams_of_vitamin_B6", lb=0, ub=None)

    # Define the objective function
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 <= 8.5)  # from r0 of vitamin B9
    model.addConstr(x1 <= 35)   # from r1 of vitamin B9
    model.addConstr(x2 <= 10.625)  # from r0 of vitamin B6
    model.addConstr(x2 <= 7)      # from r1 of vitamin B6
    model.addConstr(10*x1 + 8*x2 >= 35)  # total energy stability index
    model.addConstr(x1 + 5*x2 >= 14)    # total cardiovascular support index
    model.addConstr(-4*x1 + 10*x2 >= 0) # specific linear constraint
    model.addConstr(10*x1 + 8*x2 <= 54) # upper bound on total energy stability index
    model.addConstr(x1 + 5*x2 <= 33)    # upper bound on total cardiovascular support index

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
