
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("carbohydrate_optimization")

    # Create variables
    chicken = m.addVar(vtype=gp.GRB.INTEGER, name="chicken")
    oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")
    corn = m.addVar(vtype=gp.GRB.INTEGER, name="corn")
    knishes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="knishes")

    # Set objective function
    m.setObjective(7 * chicken + 9 * oreos + 5 * corn + 2 * knishes, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14.86 * chicken + 9.17 * oreos >= 19, "c1")
    m.addConstr(9.17 * oreos + 16.5 * corn >= 15, "c2")
    m.addConstr(14.86 * chicken + 0.36 * knishes <= 30, "c3")
    m.addConstr(9.17 * oreos + 0.36 * knishes <= 40, "c4")
    m.addConstr(16.5 * corn + 0.36 * knishes <= 64, "c5")
    m.addConstr(14.86 * chicken + 9.17 * oreos <= 51, "c6")
    m.addConstr(14.86 * chicken + 9.17 * oreos + 16.5 * corn + 0.36 * knishes <= 88, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
