
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x1 = model.addVar(vtype=GRB.INTEGER, name="chicken_breasts")
x2 = model.addVar(vtype=GRB.INTEGER, name="oreos")
x3 = model.addVar(vtype=GRB.INTEGER, name="corn_cobs")
x4 = model.addVar(vtype=GRB.CONTINUOUS, name="knishes")

# Set the objective function
model.setObjective(7*x1 + 9*x2 + 5*x3 + 2*x4, GRB.MAXIMIZE)

# Add constraints
model.addConstr(14.86*x1 + 9.17*x2 >= 19, "carb_chicken_oreos_min")
model.addConstr(9.17*x2 + 16.5*x3 >= 15, "carb_oreos_corn_min")
model.addConstr(14.86*x1 + 0.36*x4 <= 30, "carb_chicken_knishes_max")
model.addConstr(9.17*x2 + 0.36*x4 <= 40, "carb_oreos_knishes_max")
model.addConstr(16.5*x3 + 0.36*x4 <= 64, "carb_corn_knishes_max")
model.addConstr(14.86*x1 + 9.17*x2 <= 51, "carb_chicken_oreos_max")
model.addConstr(14.86*x1 + 9.17*x2 + 16.5*x3 + 0.36*x4 <= 88, "total_carb_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chicken Breasts: {x1.x}")
    print(f"Oreos: {x2.x}")
    print(f"Corn Cobs: {x3.x}")
    print(f"Knishes: {x4.x}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("No optimal solution found")
