
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="chicken_breasts", vtype=gp.GRB.INTEGER)  # chicken breasts
x2 = m.addVar(name="oreos", vtype=gp.GRB.INTEGER)  # oreos
x3 = m.addVar(name="corn_cobs", vtype=gp.GRB.INTEGER)  # corn cobs
x4 = m.addVar(name="knishes", vtype=gp.GRB.CONTINUOUS)  # knishes

# Objective function
m.setObjective(7*x1 + 9*x2 + 5*x3 + 2*x4, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(14.86*x1 + 9.17*x2 >= 19)
m.addConstr(9.17*x2 + 16.5*x3 >= 15)
m.addConstr(14.86*x1 + 0.36*x4 <= 30)
m.addConstr(9.17*x2 + 0.36*x4 <= 40)
m.addConstr(16.5*x3 + 0.36*x4 <= 64)
m.addConstr(14.86*x1 + 9.17*x2 <= 51)
m.addConstr(14.86*x1 + 9.17*x2 + 16.5*x3 + 0.36*x4 <= 51)

# Carbohydrates upper bound
m.addConstr(14.86*x1 + 9.17*x2 + 16.5*x3 + 0.36*x4 <= 88)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken breasts: ", x1.varValue)
    print("Oreos: ", x2.varValue)
    print("Corn cobs: ", x3.varValue)
    print("Knishes: ", x4.varValue)
else:
    print("The model is infeasible")
