
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")


    # Set objective function
    m.setObjective(2 * vitamin_k + 8 * vitamin_a + 8 * magnesium, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11.75 * vitamin_k + 6.07 * vitamin_a + 5.28 * magnesium >= 17, "c1")
    m.addConstr(11.75 * vitamin_k + 5.28 * magnesium >= 29, "c2")
    m.addConstr(6.07 * vitamin_a + 5.28 * magnesium <= 34, "c3")
    m.addConstr(11.75 * vitamin_k + 5.28 * magnesium <= 67, "c4")
    m.addConstr(11.75 * vitamin_k + 6.07 * vitamin_a + 5.28 * magnesium <= 68, "c5")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_k: %g' % vitamin_k.x)
        print('vitamin_a: %g' % vitamin_a.x)
        print('magnesium: %g' % magnesium.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
