
from gurobipy import *

# Create a new model
model = Model("Vitamin_Optimization")

# Define variables
x1 = model.addVar(name="vitamin_k", lb=0)
x2 = model.addVar(name="vitamin_a", lb=0)
x3 = model.addVar(name="magnesium", lb=0)

# Set the objective function
model.setObjective(2*x1 + 8*x2 + 8*x3, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11.75*x1 + 5.28*x3 >= 29, name="vitamin_k_magnesium_min")
model.addConstr(11.75*x1 + 6.07*x2 + 5.28*x3 >= 17, name="all_vitamins_min")
model.addConstr(6.07*x2 + 5.28*x3 <= 34, name="vitamin_a_magnesium_max")
model.addConstr(11.75*x1 + 5.28*x3 <= 67, name="vitamin_k_magnesium_max")
model.addConstr(11.75*x1 + 6.07*x2 + 5.28*x3 <= 68, name="all_vitamins_max")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin K: {x1.x}")
    print(f"Milligrams of Vitamin A: {x2.x}")
    print(f"Milligrams of Magnesium: {x3.x}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("No optimal solution found")
