
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # Vitamin K
    x2 = model.addVar(name="x2", lb=0)  # Vitamin A
    x3 = model.addVar(name="x3", lb=0)  # Magnesium

    # Define the objective function
    model.setObjective(2*x1 + 8*x2 + 8*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11.75*x1 + 5.28*x3 >= 29)
    model.addConstr(11.75*x1 + 6.07*x2 + 5.28*x3 >= 17)
    model.addConstr(6.07*x2 + 5.28*x3 <= 34)
    model.addConstr(11.75*x1 + 5.28*x3 <= 67)
    model.addConstr(11.75*x1 + 6.07*x2 + 5.28*x3 <= 68)

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin K: {x1.varValue}")
        print(f"Milligrams of vitamin A: {x2.varValue}")
        print(f"Milligrams of magnesium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
