
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="bottles_of_ibuprofen")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")


    # Set objective function
    m.setObjective(8*x0 + 4*x1 + 6*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 5*x1 >= 33, "c1")
    m.addConstr(11*x0 + 7*x2 >= 29, "c2")
    m.addConstr(5*x1 + 7*x2 >= 49, "c3")
    m.addConstr(11*x0 + 5*x1 + 7*x2 >= 49, "c4")
    m.addConstr(20*x0 + 26*x1 >= 23, "c5")
    m.addConstr(20*x0 + 18*x2 >= 16, "c6")
    m.addConstr(26*x1 + 18*x2 >= 14, "c7")
    m.addConstr(20*x0 + 26*x1 + 18*x2 >= 14, "c8")
    m.addConstr(5*x0 - 4*x2 >= 0, "c9")
    m.addConstr(4*x1 - 9*x2 >= 0, "c10")
    m.addConstr(20*x0 + 18*x2 <= 58, "c11")

    # Resource Constraints
    m.addConstr(11*x0 + 5*x1 + 7*x2 <= 166, "dollar_cost")
    m.addConstr(20*x0 + 26*x1 + 18*x2 <= 95, "dollar_value")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
