
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER, lb=0)
    x1 = model.addVar(name="bottles_of_ibuprofen", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="cookies", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function
    model.setObjective(8*x0 + 4*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11*x0 + 5*x1 + 7*x2 >= 49)
    model.addConstr(11*x0 + 5*x1 >= 33)
    model.addConstr(11*x0 + 7*x2 >= 29)
    model.addConstr(5*x1 + 7*x2 >= 49)
    model.addConstr(20*x0 + 26*x1 >= 23)
    model.addConstr(20*x0 + 18*x2 >= 16)
    model.addConstr(26*x1 + 18*x2 >= 14)
    model.addConstr(20*x0 + 26*x1 + 18*x2 >= 14)
    model.addConstr(5*x0 - 4*x2 >= 0)
    model.addConstr(4*x1 - 9*x2 >= 0)
    model.addConstr(20*x0 + 18*x2 <= 58)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("dish soap bottles: ", x0.varValue)
        print("bottles of ibuprofen: ", x1.varValue)
        print("cookies: ", x2.varValue)
    else:
        print("No solution found")

optimize_problem()
