
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")
pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pies")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sandwiches")
drumsticks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="drumsticks")


# Set objective function
m.setObjective(7 * cheeseburgers + 9 * pasta + 5 * pies + 4 * pickles + 9 * sandwiches + 2 * drumsticks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * cheeseburgers + 7 * pasta + 7 * pies + 2 * pickles + 1 * sandwiches + 3 * drumsticks <= 217, "protein_limit")


protein_constraints = [
    (pasta, pickles, drumsticks, 30),
    (pasta, pies, pickles, 30),
    (cheeseburgers, pickles, sandwiches, 30),
    (pies, pickles, sandwiches, 30),
    (cheeseburgers, pies, sandwiches, 30),
    (cheeseburgers, pasta, drumsticks, 30),
    (cheeseburgers, sandwiches, drumsticks, 30),
    (pasta, sandwiches, drumsticks, 30),
    (pasta, pickles, drumsticks, 20),
    (pasta, pies, pickles, 20),
    (cheeseburgers, pickles, sandwiches, 20),
    (pies, pickles, sandwiches, 20),
    (cheeseburgers, pies, sandwiches, 20),
    (cheeseburgers, pasta, drumsticks, 20),
    (cheeseburgers, sandwiches, drumsticks, 20),
    (pasta, sandwiches, drumsticks, 20),
    (pasta, pickles, drumsticks, 32),
    (pasta, pies, pickles, 32),
    (cheeseburgers, pickles, sandwiches, 32),
    (pies, pickles, sandwiches, 32),
    (cheeseburgers, pies, sandwiches, 32),
    (cheeseburgers, pasta, drumsticks, 32),
    (cheeseburgers, sandwiches, drumsticks, 32),
    (pasta, sandwiches, drumsticks, 32),
    (pasta, pickles, drumsticks, 35),
    (pasta, pies, pickles, 35),
    (cheeseburgers, pickles, sandwiches, 35),
    (pies, pickles, sandwiches, 35),
    (cheeseburgers, pies, sandwiches, 35),
    (cheeseburgers, pasta, drumsticks, 35),
    (cheeseburgers, sandwiches, drumsticks, 35),
    (pasta, sandwiches, drumsticks, 35),
     (pasta, pickles, 82, gp.GRB.LESS_EQUAL),
    (cheeseburgers, sandwiches, 152, gp.GRB.LESS_EQUAL),
    (pickles, drumsticks, 113, gp.GRB.LESS_EQUAL),
    (cheeseburgers, pies, 53, gp.GRB.LESS_EQUAL),
    (pies, pickles, 96, gp.GRB.LESS_EQUAL),
    (cheeseburgers, pasta, 114, gp.GRB.LESS_EQUAL),
    (sandwiches, drumsticks, 212, gp.GRB.LESS_EQUAL),
    (pasta, sandwiches, 67, gp.GRB.LESS_EQUAL),
    (cheeseburgers, pickles, 128, gp.GRB.LESS_EQUAL),
    (pasta, drumsticks, 207, gp.GRB.LESS_EQUAL),
    (pickles, sandwiches, 40, gp.GRB.LESS_EQUAL),
    (pasta, pies, 136, gp.GRB.LESS_EQUAL),
    (pasta, pickles, sandwiches, 60, gp.GRB.LESS_EQUAL),
    (pasta, pies, drumsticks, 199, gp.GRB.LESS_EQUAL),
    (cheeseburgers, pasta, pies, pickles, sandwiches, drumsticks, 199, gp.GRB.LESS_EQUAL)
]


for constraint in protein_constraints:
    if len(constraint) == 4:
        var1, var2, var3, value = constraint
        m.addConstr(7 * var1 + 2 * var2 + 3 * var3 >= value)
    elif len(constraint) == 5:
        var1, var2, var3, value, sense = constraint
        if sense == gp.GRB.LESS_EQUAL:
            m.addConstr(7 * var1 + 2 * var2 + 3 * var3 <= value)
        else:  # Assuming it's greater than or equal to if not less than or equal to
            m.addConstr(7 * var1 + 2 * var2 + 3 * var3 >= value)
    elif len(constraint) == 6:
        var1, var2, var3, var4, var5, var6, value, sense = constraint
        m.addConstr(8 * var1 + 7 * var2 + 7 * var3 + 2 * var4 + 1 * var5 + 3 * var6 <= value)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

