
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x = m.addVars(5, lb=0, vtype=[gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS], name=["x0", "x1", "x2", "x3", "x4"])


    # Set objective function
    m.setObjective(6*x[0] + 4*x[1] + 1*x[2] + 4*x[3] + 5*x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x[0] + 5*x[3] <= 207, "c0")
    m.addConstr(4*x[0] + 8*x[4] <= 261, "c1")
    m.addConstr(14*x[1] + 5*x[3] <= 72, "c2")
    m.addConstr(4*x[0] + 14*x[1] <= 169, "c3")
    m.addConstr(14*x[1] + 2*x[2] <= 248, "c4")
    m.addConstr(4*x[0] + 14*x[1] + 5*x[3] <= 269, "c5")
    m.addConstr(4*x[0] + 14*x[1] + 2*x[2] <= 150, "c6")
    m.addConstr(4*x[0] + 14*x[1] + 2*x[2] + 5*x[3] + 8*x[4] <= 150, "c7")
    m.addConstr(7*x[0] + 8*x[1] <= 217, "c8")
    m.addConstr(8*x[1] + 12*x[4] <= 170, "c9")
    m.addConstr(9*x[3] + 12*x[4] <= 202, "c10")
    m.addConstr(7*x[0] + 9*x[3] <= 148, "c11")
    m.addConstr(7*x[0] + 8*x[1] + 5*x[2] <= 114, "c12")
    m.addConstr(7*x[0] + 8*x[1] + 9*x[3] <= 148, "c13")
    m.addConstr(7*x[0] + 8*x[1] + 12*x[4] <= 87, "c14")
    m.addConstr(7*x[0] + 5*x[2] + 9*x[3] <= 242, "c15")
    m.addConstr(8*x[1] + 5*x[2] + 9*x[3] <= 254, "c16")
    m.addConstr(8*x[1] + 5*x[2] + 12*x[4] <= 247, "c17")
    m.addConstr(7*x[0] + 8*x[1] + 5*x[2] + 9*x[3] + 12*x[4] <= 247, "c18")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
