
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # milligrams of vitamin A
    x2 = model.addVar(name='x2', lb=0)  # milligrams of vitamin D
    x3 = model.addVar(name='x3', lb=0)  # milligrams of vitamin B4
    x4 = model.addVar(name='x4', lb=0)  # milligrams of vitamin B7
    x5 = model.addVar(name='x5', lb=0)  # grams of carbohydrates

    # Define the objective function
    model.setObjective(6 * x1 + 4 * x2 + x3 + 4 * x4 + 5 * x5, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * x1 <= 300)
    model.addConstr(7 * x1 <= 298)
    model.addConstr(14 * x2 <= 300)
    model.addConstr(8 * x2 <= 298)
    model.addConstr(2 * x3 <= 300)
    model.addConstr(5 * x3 <= 298)
    model.addConstr(5 * x4 <= 300)
    model.addConstr(9 * x4 <= 298)
    model.addConstr(8 * x5 <= 300)
    model.addConstr(12 * x5 <= 298)
    model.addConstr(4 * x1 + 5 * x4 <= 207)
    model.addConstr(4 * x1 + 8 * x5 <= 261)
    model.addConstr(14 * x2 + 5 * x4 <= 72)
    model.addConstr(4 * x1 + 14 * x2 <= 169)
    model.addConstr(14 * x2 + 2 * x3 <= 248)
    model.addConstr(4 * x1 + 14 * x2 + 5 * x4 <= 269)
    model.addConstr(4 * x1 + 14 * x2 + 2 * x3 <= 150)
    model.addConstr(4 * x1 + 14 * x2 + 2 * x3 + 5 * x4 + 8 * x5 <= 150)
    model.addConstr(7 * x1 + 8 * x2 <= 217)
    model.addConstr(8 * x2 + 12 * x5 <= 170)
    model.addConstr(9 * x4 + 12 * x5 <= 202)
    model.addConstr(7 * x1 + 9 * x4 <= 148)
    model.addConstr(7 * x1 + 8 * x2 + 5 * x3 <= 114)
    model.addConstr(7 * x1 + 8 * x2 + 9 * x4 <= 148)
    model.addConstr(7 * x1 + 8 * x2 + 12 * x5 <= 87)
    model.addConstr(7 * x1 + 5 * x3 + 9 * x4 <= 242)
    model.addConstr(8 * x2 + 5 * x3 + 9 * x4 <= 254)
    model.addConstr(8 * x2 + 5 * x3 + 12 * x5 <= 247)
    model.addConstr(7 * x1 + 8 * x2 + 5 * x3 + 9 * x4 + 12 * x5 <= 247)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
