
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    john_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
    peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")


    # Set objective function
    model.setObjective(5*john_hours + 3*peggy_hours + 4*bill_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*peggy_hours + 2*bill_hours >= 20, "paperwork_peggy_bill")
    model.addConstr(7*john_hours + 2*bill_hours >= 12, "paperwork_john_bill")
    model.addConstr(7*john_hours + 9*peggy_hours + 2*bill_hours >= 12, "paperwork_total")
    model.addConstr(4*peggy_hours + 9*bill_hours >= 18, "quit_peggy_bill")
    model.addConstr(11*john_hours + 4*peggy_hours >= 29, "quit_john_peggy")
    model.addConstr(11*john_hours + 4*peggy_hours + 9*bill_hours >= 29, "quit_total")
    model.addConstr(9*john_hours - 3*peggy_hours >= 0, "john_peggy_relation")
    model.addConstr(7*john_hours + 9*peggy_hours + 2*bill_hours <= 73, "paperwork_total_upper")
    model.addConstr(4*peggy_hours + 9*bill_hours <= 69, "quit_peggy_bill_upper")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('John Hours: %g' % john_hours.x)
        print('Peggy Hours: %g' % peggy_hours.x)
        print('Bill Hours: %g' % bill_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
