
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='hours_worked_by_John', lb=0)
    x1 = model.addVar(name='hours_worked_by_Peggy', lb=0)
    x2 = model.addVar(name='hours_worked_by_Bill', lb=0)

    # Define the objective function
    model.setObjective(5 * x0 + 3 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x0 - 3 * x1 >= 0)
    model.addConstr(7 * x0 + 2 * x2 >= 12)
    model.addConstr(9 * x1 + 2 * x2 >= 20)
    model.addConstr(11 * x0 + 4 * x1 + 9 * x2 >= 29)
    model.addConstr(4 * x1 + 9 * x2 >= 18)
    model.addConstr(7 * x0 + 9 * x1 + 2 * x2 <= 73)
    model.addConstr(4 * x1 + 9 * x2 <= 69)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by John: {x0.varValue}')
        print(f'Hours worked by Peggy: {x1.varValue}')
        print(f'Hours worked by Bill: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
