
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
apples = model.addVar(vtype=gp.GRB.INTEGER, name="apples")
hot_dogs = model.addVar(vtype=gp.GRB.INTEGER, name="hot_dogs")
oranges = model.addVar(vtype=gp.GRB.INTEGER, name="oranges")

# Set objective function
model.setObjective(2.56 * apples + 6.29 * hot_dogs + 1.2 * oranges, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * apples + 18 * oranges >= 47, "protein_constraint1")
model.addConstr(18 * apples + 13 * hot_dogs + 18 * oranges >= 47, "protein_constraint2")
model.addConstr(24 * apples + 17 * oranges >= 46, "tastiness_constraint1")
model.addConstr(10 * hot_dogs + 17 * oranges >= 77, "tastiness_constraint2")
model.addConstr(24 * apples + 10 * hot_dogs + 17 * oranges >= 77, "tastiness_constraint3")
model.addConstr(-4 * hot_dogs + 2 * oranges >= 0, "constraint4")
model.addConstr(18 * apples + 13 * hot_dogs <= 106, "constraint5")
model.addConstr(10 * hot_dogs + 17 * oranges <= 279, "constraint6")


# Resource Constraints
model.addConstr(18 * apples <= 199, "protein_apples_limit")
model.addConstr(13 * hot_dogs <= 199, "protein_hot_dogs_limit")
model.addConstr(18 * oranges <= 199, "protein_oranges_limit")
model.addConstr(24 * apples <= 301, "tastiness_apples_limit")
model.addConstr(10 * hot_dogs <= 301, "tastiness_hot_dogs_limit")
model.addConstr(17 * oranges <= 301, "tastiness_oranges_limit")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Apples: {apples.x}")
    print(f"Hot dogs: {hot_dogs.x}")
    print(f"Oranges: {oranges.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

