
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="apples")
x1 = m.addVar(vtype=GRB.INTEGER, name="hot_dogs")
x2 = m.addVar(vtype=GRB.INTEGER, name="oranges")

# Set the objective function
m.setObjective(2.56*x0 + 6.29*x1 + 1.2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(18*x0 + 13*x1 <= 106, "protein_apples_hotdogs")
m.addConstr(18*x0 + 13*x1 + 18*x2 >= 47, "total_protein")
m.addConstr(18*x0 + 18*x2 >= 47, "protein_apples_oranges")
m.addConstr(10*x1 + 17*x2 >= 77, "tastiness_hotdogs_oranges")
m.addConstr(24*x0 + 17*x2 >= 46, "tastiness_apples_oranges")
m.addConstr(24*x0 + 10*x1 + 17*x2 >= 77, "total_tastiness")
m.addConstr(-4*x1 + 2*x2 >= 0, "hotdogs_oranges_ratio")
m.addConstr(10*x1 + 17*x2 <= 279, "tastiness_hotdogs_oranges_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apples: {x0.x}")
    print(f"Hot Dogs: {x1.x}")
    print(f"Oranges: {x2.x}")
else:
    print("No optimal solution found")
