
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
apples = model.addVar(name="apples", vtype=gurobi.GRB.INTEGER)
hot_dogs = model.addVar(name="hot_dogs", vtype=gurobi.GRB.INTEGER)
oranges = model.addVar(name="oranges", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(2.56 * apples + 6.29 * hot_dogs + 1.2 * oranges, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(18 * apples + 13 * hot_dogs + 18 * oranges >= 47)  
model.addConstr(24 * apples + 17 * oranges >= 46)  
model.addConstr(10 * hot_dogs + 17 * oranges >= 77)  
model.addConstr(24 * apples + 10 * hot_dogs + 17 * oranges >= 77)  
model.addConstr(-4 * hot_dogs + 2 * oranges >= 0)  
model.addConstr(18 * apples + 13 * hot_dogs <= 106)  
model.addConstr(10 * hot_dogs + 17 * oranges <= 279)  

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Apples: {apples.varValue}")
    print(f"Hot Dogs: {hot_dogs.varValue}")
    print(f"Oranges: {oranges.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
