
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")


# Set objective function
m.setObjective(8.12*peggy**2 + 8.48*peggy*paul + 8.94*peggy*john + 5.51*laura**2 + 2.61*laura*paul + 9.03*laura*john + 9.34*paul**2 + 6.72*paul*john + 8.88*laura + 8.85*paul + 8.95*john, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.76*peggy**2 + 6.02*paul**2 >= 18)
m.addConstr(0.76*peggy + 1.22*john >= 21)
m.addConstr(0.76*peggy + 8.0*laura + 6.02*paul >= 34)
m.addConstr(0.76*peggy + 6.02*paul + 1.22*john >= 34)
m.addConstr(0.76*peggy**2 + 8.0*laura**2 + 6.02*paul**2 >= 41)
m.addConstr(0.76*peggy + 6.02*paul + 1.22*john >= 41)
m.addConstr(0.76*peggy + 8.0*laura + 6.02*paul + 1.22*john >= 41)
m.addConstr(1.33*laura + 6.98*john >= 6)
m.addConstr(9.72*peggy**2 + 9.22*paul**2 >= 15)
m.addConstr(9.72*peggy + 1.33*laura >= 13)
m.addConstr(9.72*peggy + 1.33*laura + 9.22*paul >= 12)
m.addConstr(1.33*laura**2 + 9.22*paul**2 + 6.98*john**2 >= 12)
m.addConstr(9.72*peggy**2 + 1.33*laura**2 + 9.22*paul**2 >= 17)
m.addConstr(1.33*laura + 9.22*paul + 6.98*john >= 17)
m.addConstr(9.72*peggy + 1.33*laura + 9.22*paul + 6.98*john >= 17)
m.addConstr(-6*peggy + 8*laura >= 0)
m.addConstr(0.76*peggy + 8.0*laura <= 148)
m.addConstr(8.0*laura + 6.02*paul + 1.22*john <= 166)
m.addConstr(0.76*peggy**2 + 8.0*laura**2 + 6.02*paul**2 <= 148)
m.addConstr(0.76*peggy**2 + 8.0*laura**2 + 1.22*john**2 <= 115)
m.addConstr(0.76*peggy + 6.02*paul + 1.22*john <= 89)
m.addConstr(9.72*peggy + 1.33*laura + 9.22*paul <= 41)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

