
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Peggy
x1 = m.addVar(name="x1", lb=0)  # hours worked by Laura
x2 = m.addVar(name="x2", lb=0)  # hours worked by Paul
x3 = m.addVar(name="x3", lb=0)  # hours worked by John

# Objective function
m.setObjective(8.12*x0**2 + 8.48*x0*x2 + 8.94*x0*x3 + 5.51*x1**2 + 2.61*x1*x2 + 9.03*x1*x3 + 9.34*x2**2 + 6.72*x2*x3 + 8.88*x1 + 8.85*x2 + 8.95*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(0.76*x0 == 0.76)
m.addConstr(9.72*x0 == 9.72)
m.addConstr(8.0*x1 == 8.0)
m.addConstr(1.33*x1 == 1.33)
m.addConstr(6.02*x2 == 6.02)
m.addConstr(9.22*x2 == 9.22)
m.addConstr(1.22*x3 == 1.22)
m.addConstr(6.98*x3 == 6.98)
m.addConstr(0.76**2*x0**2 + 6.02**2*x2**2 >= 18)
m.addConstr(0.76*x0 + 1.22*x3 >= 21)
m.addConstr(0.76*x0 + 8.0*x1 + 6.02*x2 >= 34)
m.addConstr(0.76*x0 + 6.02*x2 + 1.22*x3 >= 34)
m.addConstr(0.76**2*x0**2 + 8.0**2*x1**2 + 6.02**2*x2**2 >= 41)
m.addConstr(0.76*x0 + 6.02*x2 + 1.22*x3 >= 41)
m.addConstr(0.76*x0 + 8.0*x1 + 6.02*x2 + 1.22*x3 >= 41)
m.addConstr(1.33*x1 + 6.98*x3 >= 6)
m.addConstr(9.72**2*x0**2 + 9.22**2*x2**2 >= 15)
m.addConstr(9.72*x0 + 1.33*x1 >= 13)
m.addConstr(9.72*x0 + 1.33*x1 + 9.22*x2 >= 12)
m.addConstr(1.33**2*x1**2 + 9.22**2*x2**2 + 6.98**2*x3**2 >= 12)
m.addConstr(9.72**2*x0**2 + 1.33**2*x1**2 + 9.22**2*x2**2 >= 17)
m.addConstr(1.33*x1 + 9.22*x2 + 6.98*x3 >= 17)
m.addConstr(9.72*x0 + 1.33*x1 + 9.22*x2 + 6.98*x3 >= 17)
m.addConstr(-6*x0 + 8*x1 >= 0)
m.addConstr(0.76*x0 + 8.0*x1 <= 148)
m.addConstr(8.0*x1 + 6.02*x2 + 1.22*x3 <= 166)
m.addConstr(0.76**2*x0**2 + 8.0**2*x1**2 + 6.02**2*x2**2 <= 148)
m.addConstr(0.76**2*x0**2 + 8.0**2*x1**2 + 1.22**2*x3**2 <= 115)
m.addConstr(0.76*x0 + 6.02*x2 + 1.22*x3 <= 89)
m.addConstr(9.72*x0 + 1.33*x1 + 9.22*x2 <= 41)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
