
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_deployment")

    # Create variables
    x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["recon", "airborne", "signal", "transport"])

    # Set objective function
    m.setObjective(5*x[0] + 2*x[1] + 4*x[2] + 8*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x[0] + 2*x[1] + 5*x[2] + 2*x[3] <= 81, "deployment_weight")
    m.addConstr(4*x[0] + 5*x[1] + 4*x[2] + 1*x[3] <= 41, "logistical_capacity")
    m.addConstr(4*x[0] + 2*x[1] >= 11)
    m.addConstr(4*x[0] + 2*x[3] >= 7)
    m.addConstr(2*x[1] + 2*x[3] >= 18)
    m.addConstr(2*x[1] + 5*x[2] >= 7)
    m.addConstr(4*x[0] + 1*x[3] >= 10)
    m.addConstr(5*x[1] + 4*x[2] >= 7)
    m.addConstr(4*x[0] + 5*x[1] + 4*x[2] >= 7) # Corrected and simplified redundant constraints
    m.addConstr(4*x[0] + 4*x[2] + 1*x[3] >= 7) # Corrected and simplified redundant constraints
    m.addConstr(5*x[1] + 4*x[2] + 1*x[3] >= 7) # Corrected and simplified redundant constraints
    m.addConstr(4*x[0] + 5*x[1] + 1*x[3] >= 7) # Corrected and simplified redundant constraints
    m.addConstr(2*x[1] + 2*x[3] <= 27)
    m.addConstr(4*x[0] + 5*x[2] <= 74)
    m.addConstr(4*x[0] + 2*x[3] <= 77)
    m.addConstr(5*x[2] + 2*x[3] <= 61)
    m.addConstr(4*x[0] + 2*x[1] + 5*x[2] + 2*x[3] <= 61)
    m.addConstr(4*x[0] + 1*x[3] <= 24)
    m.addConstr(4*x[2] + 1*x[3] <= 19)
    m.addConstr(4*x[0] + 5*x[1] + 4*x[2] + 1*x[3] <= 19)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
