
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="signal_platoons", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="transportation_companies", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(5 * x0 + 2 * x1 + 4 * x2 + 8 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x0 + 2 * x1 >= 11)
m.addConstr(4 * x0 + 2 * x3 >= 7)
m.addConstr(2 * x1 + 2 * x3 >= 18)
m.addConstr(2 * x1 + 5 * x2 >= 7)
m.addConstr(4 * x0 + x3 >= 10)
m.addConstr(5 * x1 + 4 * x2 >= 7)
m.addConstr(4 * x0 + 5 * x1 + 4 * x2 >= 6)
m.addConstr(4 * x0 + 4 * x2 + x3 >= 6)
m.addConstr(5 * x1 + 4 * x2 + x3 >= 6)
m.addConstr(4 * x0 + 5 * x1 + x3 >= 6)
m.addConstr(4 * x0 + 4 * x2 + x3 >= 6)
m.addConstr(5 * x1 + 4 * x2 + x3 >= 6)
m.addConstr(4 * x0 + 5 * x1 + x3 >= 6)
m.addConstr(4 * x0 + 4 * x2 + x3 >= 7)
m.addConstr(5 * x1 + 4 * x2 + x3 >= 7)
m.addConstr(4 * x0 + 5 * x1 + x3 >= 7)
m.addConstr(4 * x0 + 5 * x1 + 4 * x2 >= 5)
m.addConstr(4 * x0 + 4 * x2 + x3 >= 5)
m.addConstr(5 * x1 + 4 * x2 + x3 >= 5)
m.addConstr(4 * x0 + 5 * x1 + x3 >= 5)
m.addConstr(2 * x1 + 2 * x3 <= 27)
m.addConstr(4 * x0 + 5 * x2 <= 74)
m.addConstr(4 * x0 + 2 * x3 <= 77)
m.addConstr(5 * x2 + 2 * x3 <= 61)
m.addConstr(4 * x0 + 2 * x1 + 5 * x2 + 2 * x3 <= 61)
m.addConstr(4 * x0 + x3 <= 24)
m.addConstr(4 * x2 + x3 <= 19)
m.addConstr(4 * x0 + 5 * x1 + 4 * x2 + x3 <= 19)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Reconnaissance troops: ", x0.varValue)
    print("Airborne infantry companies: ", x1.varValue)
    print("Signal platoons: ", x2.varValue)
    print("Transportation companies: ", x3.varValue)
else:
    print("The model is infeasible")
