
import gurobipy as gp

# Create a new model
model = gp.Model("minimize_quit_likelihood")

# Create variables
john_hours = model.addVar(vtype=gp.GRB.INTEGER, name="john_hours")
mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")

# Set objective function
model.setObjective(7.35 * john_hours + 9.07 * mary_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.51 * john_hours + 0.47 * mary_hours >= 42, "combined_quit_likelihood_min")
model.addConstr(0.51 * john_hours + 0.47 * mary_hours <= 79, "combined_quit_likelihood_max")
model.addConstr(1 * john_hours - 3 * mary_hours >= 0, "hours_constraint")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Value: {model.objVal}")
    print(f"John's Hours: {john_hours.x}")
    print(f"Mary's Hours: {mary_hours.x}")

