
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_John")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")

# Set the objective function
m.setObjective(7.35*x1 + 9.07*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(0.51*x1 + 0.47*x2 >= 42, name="min_likelihood_constraint")
m.addConstr(0.51*x1 + 0.47*x2 <= 79, name="max_likelihood_constraint")
m.addConstr(x1 - 3*x2 >= 0, name="hours_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {x1.x}")
    print(f"Hours worked by Mary: {x2.x}")
else:
    print("No optimal solution found.")
