
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_John', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_Mary', vtype=gurobi.GRB.INTEGER)

    # Set the objective function
    model.setObjective(7.35 * x1 + 9.07 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.51 * x1 + 0.47 * x2 >= 42)
    model.addConstr(0.51 * x1 + 0.47 * x2 <= 79)
    model.addConstr(x1 - 3 * x2 >= 0)

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by John: {x1.varValue}')
        print(f'Hours worked by Mary: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
