
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b5 = m.addVar(lb=0, name="vitamin_b5")  # milligrams of vitamin B5
vitamin_b12 = m.addVar(lb=0, name="vitamin_b12") # milligrams of vitamin B12

# Set objective function
m.setObjective(5 * vitamin_b5 + 5 * vitamin_b12, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * vitamin_b5 + 32 * vitamin_b12 >= 32, "cardiovascular_min")
m.addConstr(11 * vitamin_b5 + 10 * vitamin_b12 >= 36, "cognitive_min")
m.addConstr(6 * vitamin_b5 + 8 * vitamin_b12 >= 28, "digestive_min")
m.addConstr(-10 * vitamin_b5 + 9 * vitamin_b12 >= 0, "custom_constraint")
m.addConstr(3 * vitamin_b5 + 32 * vitamin_b12 <= 44, "cardiovascular_max")
m.addConstr(11 * vitamin_b5 + 10 * vitamin_b12 <= 88, "cognitive_max")
m.addConstr(6 * vitamin_b5 + 8 * vitamin_b12 <= 86, "digestive_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Vitamin B5: {vitamin_b5.x}')
    print(f'Vitamin B12: {vitamin_b12.x}')
    print(f'Objective Value: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}.')

